program md
  IMPLICIT none
! Time step in units of 1.018E-14 sec, mass of silicon, boltzmann constant
  REAL(8), PARAMETER :: dt = 0.001d0  !MD timestep
  REAL(8), PARAMETER :: rmass = 28.d0 !mass of the particles
  REAL(8), PARAMETER :: rkboltz=8.6173855d-5  !Boltzman constant
  REAL(8), PARAMETER :: temp=300 !temperature
  INTEGER, PARAMETER :: nstep=10000 !number of MD steps

  INTEGER, PARAMETER :: nat=256 !number of atoms

! rxyz are the atomic positions, vxyz the velocities and fxyz and gxyz the
! current and previous forces needed for the velocity verlet algorithm
  REAL(8), DIMENSION(3,nat) :: rxyz  !atom postitions
  REAL(8), DIMENSION(3,nat) :: vxyz  !velocities
  REAL(8), DIMENSION(3,nat) :: fxyz  !forces
  REAL(8), DIMENSION(3,nat) :: gxyz  !2nd forces (old forces)
  REAL(8), DIMENSION(3,3) :: alat  !lattice vecotrs
  REAL(8), DIMENSION(3,3) :: deralat !derivative of lattice vectors

  REAL(8) :: dxx, dyx, dyy !only for file reading not used by you
  REAL(8) :: dzx, dzy, dzz !only for file reading not used by you

  INTEGER :: natp !only for file reading not used by you

  !Dummy variables
  INTEGER :: iat
  INTEGER :: i,j,l

  CHARACTER(17) filename
  CHARACTER(2) :: symb(nat) !atom type symbol of the atoms
  LOGICAL debug


! introduced variables

  REAL(8) :: ekinetic  !kinetic energy used for initializing the velocities
  INTEGER :: nf !degrees of freedom
  REAL(8) :: ekin  !kinetic energy during the md runs
  REAL(8) :: epot  !potential energy during the md runs
  REAL(8) :: etot  !total energy during the md runs
  REAL(8) :: energy0 !total energy at the first md step
  REAL(8) :: temp_step !temperatur at a each md step

  INTEGER :: istep !md step dummy variable

  CHARACTER(8) :: var



  debug=.false.

  OPEN(file='POSMD.ascii',unit=10)
    READ(10,*) natp
    IF (debug) WRITE(*,*) natp
    IF (natp.ne.nat) STOP 'nat'
    READ(10,*) dxx,dyx,dyy
    IF (debug) WRITE(*,*)  dxx,dyx,dyy
    READ(10,*) dzx,dzy,dzz
    IF (debug) WRITE(*,*)  dzx,dzy,dzz
    alat(1,1)=dxx
    alat(2,1)=0.d0
    alat(3,1)=0.d0

    alat(1,2)=dyx
    alat(2,2)=dyy
    alat(3,2)=0.d0

    alat(1,3)=dzx
    alat(2,3)=dzy
    alat(3,3)=dzz

    DO i = 1, nat
      READ(10, *) ( rxyz(j, i), j = 1, 3) ,symb(i)
      IF (debug) WRITE(*,'(3(2x,e12.5),4x,a,3x,i4)') ( rxyz(j, i), j = 1, 3) ,symb(iat), i
    ENDDO
  CLOSE(10)


  !TODO generate Maxwell distributed velocisties

  !TODO generating Gaussian velocities
  !TODO elimination of the momentum of the center of mass
  !TODO rescale velocities such that the temperature is Temp

  !TODO get initial forces before MD loop


  OPEN(file="md_out.dat", unit=11)
  WRITE(11,*) "# istep, ekin, epot, etot, temp"
  !start md loop
  OPEN(10,file='mdpos.xyz')
  DO istep=1,nstep
    !TODO update postions (Velocity Verlet Update)


    !TODO update forces

    !TODO new forces to old forces

    !TODO update velocisties

    !TODO calculate kinetic energy

    !TODO calculate total energy

    IF(istep .eq. 1) energy0=etot

    !TODO calculate actual temperature

    !writte information to file
    WRITE(11,'(5(1x,e24.17))') istep+0.d0, ekin, epot, etot, temp_step-energy0

    !write every 100th postion to file
    IF(MOD(istep,100) .eq. 0) THEN
      WRITE(*,*) "MD-STEP:  ", istep
      WRITE(10,*) nat
      WRITE(10,*) "MD STEP:    ",istep
      DO iat=1, nat
        WRITE(10,'(A,4x,3(1x,e24.17))') symb(iat),(rxyz(l,iat),l=1,3)
      ENDDO
    ENDIF

  ENDDO
  CLOSE(10)
END




!>  generates 3*nat random numbers distributed according to  exp(-.5*vxyz**2)
subroutine gausdist(nat,vxyz)
  IMPLICIT none
  INTEGER :: nat
  REAL(8), DIMENSION(3*nat) :: vxyz

  !local variables
  INTEGER :: i
  REAL(8) :: t1
  REAL(8) :: t2
  REAL(8) :: tt
  REAL(8) :: s1
  REAL(8) :: s2
  REAL(8), PARAMETER :: eps=1.d-8


  DO i=1,3*nat-1,2
     CALL random_number(s1)
     t1=eps+(1.d0-2.d0*eps)*dble(s1)
     CALL random_number(s2)
     t2=dble(s2)
     tt=sqrt(-2.d0*log(t1))
     vxyz(i)=tt*cos(6.28318530717958648d0*t2)
     vxyz(i+1)=tt*sin(6.28318530717958648d0*t2)
  ENDDO
  CALL random_number(s1)
  t1=eps+(1.d0-2.d0*eps)*dble(s1)
  CALL random_number(s2)
  t2=dble(s2)
  tt=sqrt(-2.d0*log(t1))
  vxyz(3*nat)=tt*cos(6.28318530717958648d0*t2)

end subroutine gausdist


subroutine moment(nat,vxyz)
  IMPLICIT none
  INTEGER :: nat
  REAL(8), DIMENSION(3,nat) :: vxyz

  !local variables
  INTEGER :: iat
  REAL(8) :: sx
  REAL(8) :: sy
  REAL(8) :: sz



  sx=0.d0 ; sy=0.d0 ; sz=0.d0
  DO iat=1,nat
    sx=sx+vxyz(1,iat)
    sy=sy+vxyz(2,iat)
    sz=sz+vxyz(3,iat)
  ENDDO
  WRITE(*,'(a,3(1pe11.3))') 'momentum',sx,sy,sz

end subroutine moment


subroutine elim_moment(nat,vxyz)
  IMPLICIT none
  INTEGER :: nat
  REAL(8), DIMENSION(3,nat) :: vxyz

  !local variables
  INTEGER :: iat
  REAL(8) :: sx
  REAL(8) :: sy
  REAL(8) :: sz



  sx=0.d0 ; sy=0.d0 ; sz=0.d0
  DO iat=1,nat
    sx=sx+vxyz(1,iat)
    sy=sy+vxyz(2,iat)
    sz=sz+vxyz(3,iat)
  ENDDO
  sx=sx/nat ; sy=sy/nat ; sz=sz/nat
  DO iat=1,nat
    vxyz(1,iat)=vxyz(1,iat)-sx
    vxyz(2,iat)=vxyz(2,iat)-sy
    vxyz(3,iat)=vxyz(3,iat)-sz
  ENDDO

end subroutine elim_moment


subroutine velnorm(nat,ekinetic,vxyz)
! scales the velocities to kinetic energy ekinetic
  IMPLICIT none
  INTEGER :: nat
  REAL(8) :: ekinetic
  REAL(8), DIMENSION(3,nat) :: vxyz
  !local variables
  INTEGER :: iat
  REAL(8) :: rkin,rkinsum,sclvel

  !C      Kinetic energy of the initial velocities
  rkinsum= 0.d0
  DO iat=1,nat
    rkinsum= rkinsum+vxyz(1,iat)**2+vxyz(2,iat)**2+vxyz(3,iat)**2
  ENDDO
  rkin=.5d0*rkinsum/(3*nat-6)

  !C      Rescaling of velocities to get target kinetic energy
  sclvel= dsqrt(ekinetic/rkin)
  DO iat=1,nat
    vxyz(1,iat)=vxyz(1,iat)*sclvel
    vxyz(2,iat)=vxyz(2,iat)*sclvel
    vxyz(3,iat)=vxyz(3,iat)*sclvel
  ENDDO

end subroutine velnorm
