program maxwell
  IMPLICIT none

  REAL(8), PARAMETER :: rkboltz=8.6173855d-5 !Boltzman constant
  REAL(8), PARAMETER :: temp=300 !Temperature
  INTEGER, PARAMETER :: nbin = 50 !number of bins for the histogram

  INTEGER, PARAMETER :: nat=256 !number of atoms

  REAL(8), DIMENSION(3,nat) :: rxyz !atomic postitions
  REAL(8), DIMENSION(3,nat) :: vxyz !velocities

  REAL(8), DIMENSION(3,3) :: alat !lattice vecotrs NOT USED FOR THIS EXERCISE

  REAL(8) :: dxx, dyx, dyy  !just used for reading the file
  REAL(8) :: dzx, dzy, dzz  !just used for reading the file

  INTEGER :: natp !just used for reading the file

  !DUMMY VARIABLES
  INTEGER :: iat
  INTEGER :: i,j,l

  CHARACTER(17) filename
  CHARACTER(2) symb !symbols of the atoms
  LOGICAL debug  !variable to debug the code properly


! introduced variables
! This are the variables you need to do this exercise successfull
  REAL(8), PARAMETER :: temp=300
  INTEGER, PARAMETER :: nbin = 50

  REAL(8) :: ekinetic
  REAL(8) :: v
  REAL(8) :: vmax
  REAL(8), DIMENSION(nbin) :: distribution
  INTEGER :: nf
  INTEGER :: ind


  debug=.false.

  OPEN(file='POSMD.ascii',unit=10)
    READ(10,*) natp
    IF (debug) WRITE(*,*) natp
    IF (natp.ne.nat) STOP 'nat'
    READ(10,*) dxx,dyx,dyy
    IF (debug) WRITE(*,*)  dxx,dyx,dyy
    READ(10,*) dzx,dzy,dzz
    IF (debug) WRITE(*,*)  dzx,dzy,dzz
    alat(1,1)=dxx
    alat(2,1)=0.d0
    alat(3,1)=0.d0

    alat(1,2)=dyx
    alat(2,2)=dyy
    alat(3,2)=0.d0

    alat(1,3)=dzx
    alat(2,3)=dzy
    alat(3,3)=dzz

    DO i = 1, nat
      READ(10, *) ( rxyz(j, i), j = 1, 3) ,symb
      IF (debug) WRITE(*,'(3(2x,e12.5),4x,a,3x,i4)') ( rxyz(j, i), j = 1, 3) ,symb, i
    ENDDO
  CLOSE(10)


  !Exercise from here
  !generate Maxwell distributed velocisties
  nf = 3*nat-3
  ekinetic = 0.5d0*nf*rkboltz*temp

  !TODO generating Gaussian velocities

  !TODO elimination of the momentum of the center of mass

  !TODO rescale velocities such that the temperature is Temp

  !TODO find the maximal velocity for performing the histogram



! TODO divide 0-vmax into nbins and take vmax to be equal to nbin
! the infinitesimal width is dv = vmax/nbin
! so [0-dv) corresponds to distr(0)
! [dv-2dv) corresponds to distr(1)
!in genetral [i*dv-(i+1)dv) corresponds to ditsr(i)



! TODO write the histogram to an output file


END




!>  generates 3*nat random numbers distributed according to  exp(-.5*vxyz**2)
subroutine gausdist(nat,vxyz)
  IMPLICIT none
  INTEGER :: nat
  REAL(8), DIMENSION(3*nat) :: vxyz

  !local variables
  INTEGER :: i
  REAL(8) :: t1
  REAL(8) :: t2
  REAL(8) :: tt
  REAL(8) :: s1
  REAL(8) :: s2
  REAL(8), PARAMETER :: eps=1.d-8


  DO i=1,3*nat-1,2
     CALL random_number(s1)
     t1=eps+(1.d0-2.d0*eps)*dble(s1)
     CALL random_number(s2)
     t2=dble(s2)
     tt=sqrt(-2.d0*log(t1))
     vxyz(i)=tt*cos(6.28318530717958648d0*t2)
     vxyz(i+1)=tt*sin(6.28318530717958648d0*t2)
  END DO
  CALL random_number(s1)
  t1=eps+(1.d0-2.d0*eps)*dble(s1)
  CALL random_number(s2)
  t2=dble(s2)
  tt=sqrt(-2.d0*log(t1))
  vxyz(3*nat)=tt*cos(6.28318530717958648d0*t2)

END SUBROUTINE gausdist


subroutine moment(nat,vxyz)
  IMPLICIT none
  INTEGER :: nat
  REAL(8), DIMENSION(3,nat) :: vxyz

  !local variables
  INTEGER :: iat
  REAL(8) :: sx
  REAL(8) :: sy
  REAL(8) :: sz



  sx=0.d0 ; sy=0.d0 ; sz=0.d0
  DO iat=1,nat
     sx=sx+vxyz(1,iat)
     sy=sy+vxyz(2,iat)
     sz=sz+vxyz(3,iat)
  END DO
  WRITE(*,'(a,3(1pe11.3))') 'momentum',sx,sy,sz

END SUBROUTINE moment


subroutine elim_moment(nat,vxyz)
  IMPLICIT none
  INTEGER :: nat
  REAL(8), DIMENSION(3,nat) :: vxyz

  !local variables
  INTEGER :: iat
  REAL(8) :: sx
  REAL(8) :: sy
  REAL(8) :: sz



  sx=0.d0 ; sy=0.d0 ; sz=0.d0
  DO iat=1,nat
     sx=sx+vxyz(1,iat)
     sy=sy+vxyz(2,iat)
     sz=sz+vxyz(3,iat)
  END DO
  sx=sx/nat ; sy=sy/nat ; sz=sz/nat
  DO iat=1,nat
     vxyz(1,iat)=vxyz(1,iat)-sx
     vxyz(2,iat)=vxyz(2,iat)-sy
     vxyz(3,iat)=vxyz(3,iat)-sz
  END DO

END SUBROUTINE elim_moment


subroutine velnorm(nat,ekinetic,vxyz)
! scales the velocities to kinetic energy ekinetic
  IMPLICIT none
  INTEGER :: nat
  REAL(8) :: ekinetic
  REAL(8), DIMENSION(3,nat) :: vxyz
  !local variables
  INTEGER :: iat
  REAL(8) :: rkin,rkinsum,sclvel

  !C      Kinetic energy of the initial velocities
  rkinsum= 0.d0
  DO iat=1,nat
!     if (.not. at%lfrztyp(iat)) then
        rkinsum= rkinsum+vxyz(1,iat)**2+vxyz(2,iat)**2+vxyz(3,iat)**2
!     end if
  END DO
  rkin=.5d0*rkinsum/(3*nat-6)
  !       write(*,*) 'rkin,ekinetic',rkin,ekinetic

  !C      Rescaling of velocities to get target kinetic energy
  sclvel= dsqrt(ekinetic/rkin)
  DO iat=1,nat
        vxyz(1,iat)=vxyz(1,iat)*sclvel
        vxyz(2,iat)=vxyz(2,iat)*sclvel
        vxyz(3,iat)=vxyz(3,iat)*sclvel
  END DO

END SUBROUTINE velnorm
