
! assuming m=1


program HbrydeMonteCarlo
  IMPLICIT NONE
  REAL(8), PARAMETER :: dt = 0.05d0  !timestep for verlet algorithm
  REAL(8), PARAMETER :: x0 = 0.d0    !initial position
  REAL(8), PARAMETER :: v0 = -2.0d0  !initial velocity
  REAL(8), PARAMETER :: ekintarget = 0.5d0  !target kinetic energy for velocity distribution
  INTEGER, PARAMETER :: nMD = 10  !MD steps in the hybride MC part
  INTEGER, PARAMETER :: nhist = 100  !number of bins in the histogram

  REAL(8) :: x ! position
  REAL(8) :: v ! velocity
  REAL(8) :: xtmp ! temporary postition
  REAL(8) :: ekin ! kintetic energy
  REAL(8) :: epot ! potential energy
  REAL(8) :: f ! force (derivative of the potential energy)
  REAL(8) :: etot0 ! total energy before MD in hybride MCMD
  REAL(8) :: etot1 ! total energy after MD in hybride MCMD
  REAL(8) :: alpha
  REAL(8) :: rnd !random number
  REAL(8) :: boxMueller ! declaration of the box muller function
  REAL(8) :: hist(nhist) !histogram
  REAL(8) :: pboltzmann(nhist) !boltzmann distribution
  ! dummy variables
  INTEGER :: i, j, iv


  ! MD part

  x = x0
  v = v0
  OPEN(unit=10, file="MD.dat")
  DO i=1,10000
    CALL verlet(x, v, dt)
    CALL energyAndForce(x, epot, f)
    ekin = 0.5d0 * v**2

    ! TODO implemnt the periodic function


    WRITE(10,*), 'MD', i, x, v, epot, ekin, epot + ekin


  END DO
  CLOSE(10)

  ! MC part

  hist = 0.d0

  x = x0
  DO i=1,100000
    ! ekin = v**2 / 2
    ! p(ekin) = exp(-ekin / ekintarget) = exp(-v**2 / (2 * ekintarget)) -> Gaussian with sigma**2 = ekintarget

    ! TODO use the Box-Mueller transformation and ekintarget to get a velocity
    ! then calculate the energy and forces, the kintetic and the total energy
    ! etot0

    ! performing nMD steps
    xtmp = x
    DO j=1,nMD
      CALL verlet(xtmp, v, dt)
    END DO

    ! TODO calculate again the energy and forces, the kinetic energy and the
    ! total energy etot1

    ! TODO calculate alpha = exp(-(e1-0)/ekin)

    CALL random_number(rnd)

    IF (rnd < alpha) THEN
      x = xtmp
    END IF

    x = modulo(x, 1.d0)

    j = int(x * nhist) + 1.d0
    hist(j) = hist(j) + 1.d0


  END DO

  ! implementation of the histogram
  DO i=1,nhist
    x = (i-0.5d0) / nhist
    CALL energyAndForce(x, epot, f)
    pboltzmann(i) = exp(-1.d0 * epot / ekintarget)
  END DO

  pboltzmann = pboltzmann / sum(pboltzmann)
  hist = hist / sum(hist)
  OPEN(unit=11, file="MCMD.dat")
  DO i=1,nhist
    WRITE(11,*), 'HMC', (i-0.5d0) / nhist, pboltzmann(i), hist(i)
  END DO
  CLOSE(11)


end program

function boxMueller() result(r)
  IMPLICIT NONE
  REAL(8) :: r ! Box Muller transformed random number
  REAL(8) :: x, y !initial random numbers
  REAL(8), PARAMETER :: PI = 4.d0 * atan(1.d0)

  CALL random_number(x)
  CALL random_number(y)

  !TODO implement the Box-Muller transformation

end function


subroutine verlet(x, v, dt)
  REAL(8), INTENT(INOUT) :: x !position
  REAL(8), INTENT(INOUT) :: v !velocity
  REAL(8), INTENT(IN) :: dt !timestep
  REAL(8) :: vhalf ! see equations
  REAL(8) :: f !force
  REAL(8) :: e !energy

  CALL energyAndForce(x, e, f)
  ! TODO implement equation 71
  ! TODO implement equation 72
  CALL energyAndForce(x, e, f)
  ! TODO implement equation 73

end subroutine

subroutine energyAndForce(x, e, f)
  IMPLICIT NONE
  REAL(8), INTENT(IN) :: x ! postition
  REAL(8), INTENT(OUT) :: e ! energy
  REAL(8), INTENT(OUT) :: f ! force
  REAL(8), PARAMETER :: PI = 4.d0 * atan(1.d0)

  ! TODO implent periodic potential and its derivative
  ! f = -de/dx


end subroutine
